<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use yii\widgets\MaskedInput;

/* @var $this yii\web\View */
/* @var $model app\models\Application */
/* @var $form ActiveForm */
?>

<div class="application-form">

    <h1>Анкета сотрудника</h1>

    <?php $form = ActiveForm::begin([
        'options' => ['enctype' => 'multipart/form-data']
    ]); ?>
    <div class="row">
        <div class="col-md-4">
            <?= $form->field($model, 'surname')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'patronymic')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-4">
            <?= $form->field($model, 'photo')->fileInput(['accept' => 'image/jpeg,image/jpg,application/pdf']) ?>
            <?php if ($model->photo): ?>
                <div class="current-file">
                    <small>Текущее фото: <?= $model->photo ?></small>
                </div>
            <?php endif; ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'date_birthday')->input('date') ?>
        </div>
        <div class="col-md-4">
            <?= $form->field($model, 'gender')->radioList([
                'unspecified' => 'Не указано',
                'male' => 'Мужской',
                'female' => 'Женский'
            ]) ?>
        </div>
    </div>
    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'country')->textInput(['maxlength' => true]) ?>
        </div>
        <div class="col-md-6">
            <?= $form->field($model, 'phone_number')->widget(MaskedInput::class, [
                'mask' => '+7(999)-999-99-99',
            ]) ?>
        </div>
    </div>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'email')->textInput(['maxlength' => true]) ?>
        </div>
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Паспортные данные</h3>
        </div>
        <div class="panel-body">
            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'passport')->widget(MaskedInput::class, [
                        'mask' => '9999-999999',
                    ]) ?>
                </div>
            </div>
            <?= $form->field($model, 'passportFiles[]')->fileInput([
                'multiple' => true,
                'accept' => 'image/jpeg,image/jpg,application/pdf'
            ]) ?>

            <?php if ($model->passport): ?>
                <div class="current-files">
                    <small>Текущие файлы паспорта:</small>
                    <?php
                    $passportFiles = explode('|', $model->passport);
                    foreach ($passportFiles as $file): ?>
                        <div><small><?= $file ?></small></div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Образование</h3>
        </div>
        <div class="panel-body">
            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'education')->dropDownList([
                        'basic_general' => 'Основное общее',
                        'secondary_general' => 'Среднее общее',
                        'secondary_professional' => 'Среднее профессиональное',
                        'higher' => 'Высшее'
                    ], ['prompt' => 'Выберите образование']) ?>
                </div>
                <div class="col-md-6">
                    <?= $form->field($model, 'education_organization')->textInput(['maxlength' => true]) ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'special_qual')->textInput(['maxlength' => true]) ?>
                </div>
                <div class="col-md-6">
                    <?= $form->field($model, 'diplom')->widget(MaskedInput::class, [
                        'mask' => '999999-9999999',
                    ]) ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'scan_diplom')->textInput(['maxlength' => true]) ?>
                </div>
            </div>
        </div>
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Работа и документы</h3>
        </div>
        <div class="panel-body">
            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'snils')->widget(MaskedInput::class, [
                        'mask' => '999-999-999 99',
                    ]) ?>
                </div>
                <div class="col-md-6">
                    <?= $form->field($model, 'place_work')->textInput(['maxlength' => true]) ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <?= $form->field($model, 'post')->textInput(['maxlength' => true]) ?>
                </div>
                <div class="col-md-6">
                    <?= $form->field($model, 'work_experience')->textInput(['maxlength' => true]) ?>
                </div>
            </div>
        </div>
    </div>
    <div class="panel panel-default">
        <div class="panel-heading">
            <h3 class="panel-title">Дополнительная информация</h3>
        </div>
        <div class="panel-body">
            <div class="row">
                <div class="col-md-12">
                    <?= $form->field($model, 'health')->textarea(['rows' => 3]) ?>
                </div>
            </div>

            <div class="row">
                <div class="col-md-12">
                    <?= $form->field($model, 'extra_info')->textarea(['rows' => 4]) ?>
                </div>
            </div>
        </div>
    </div>

    <div class="form-group">
        <?= Html::submitButton('Передать данные', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>