<?php use yii\bootstrap5\Html;
use yii\helpers\Url; ?>
<div class="kabinet-default-index">
    <div class="kab-title d-flex justify-content-center">
        <h1>Личный кабинет</h1>
    </div>
    <div class="kab-buttons">
        <a class="btn-primary text-decoration-none d-flex justify-content-center" href="<?= Url::toRoute(['/kabinet/default/pass']); ?>">Изменить пароль</a>
        <a class="btn-primary text-decoration-none d-flex justify-content-center" href="<?= Url::toRoute(['/kabinet/default/updateemail']); ?>">Изменить email</a>
    </div>
    <div class="d-flex justify-content-center"><h3>Мои анкеты</h3></div>


    <?php foreach ($applications as $application): ?>

        <div class="application-item mb-4 p-3 border rounded">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div>
                    <?= Html::a('Редактировать', ['update', 'id' => $application->id], [
                        'class' => 'btn btn-primary btn-sm'
                    ]) ?>
                    <?= Html::a('Удалить', ['delete', 'id' => $application->id], [
                        'class' => 'btn btn-danger btn-sm',
                        'data' => [
                            'confirm' => 'Удалить заявку?',
                            'method' => 'post',
                        ],
                    ]) ?>
                </div>
            </div>

            <p>Фамилия: <?= $application->surname ?> </p>
            <p>Имя: <?= $application->name ?> </p>
            <p>Отчество: <?= $application->patronymic ?> </p>
            <p>Дата рождения: <?= $application->date_birthday ?> </p>
            <p>Пол: <?= $application->gender ?> </p>
            <p>Гражданство: <?= $application->country ?> </p>
            <p>Паспорт: <?= $application->passport ?> </p>
            <p>Образование: <?= $application->education ?> </p>
            <p>Название образовательной организации, в которой получил
                образование: <?= $application->education_organization ?> </p>
            <p>Специальность и квалификация по диплому: <?= $application->special_qual ?> </p>
            <p>Серия и номер диплома об образовании: <?= $application->diplom ?> </p>
            <p>СНИЛС: <?= $application->snils ?> </p>
            <p>Место работы:<?= $application->place_work ?> </p>
            <p>Должность: <?= $application->post ?> </p>
            <p>Стаж работы:<?= $application->work_experience ?> </p>
            <p>Здоровье: <?= $application->health ?> </p>
            <p>Номер телефона: <?= $application->phone_number ?> </p>
            <p>Email: <?= $application->email ?> </p>
            <p>Дополнительная информация: <?= $application->extra_info ?> </p>
            <?php if ($application->scan_diplom): ?>
                <?= Html::img('@web/uploads/' . $application->scan_diplom, ['alt' => 'Скан диплома', 'style' => 'width:100px']) ?>
            <?php endif; ?>
            <?php if ($application->photo): ?>
                <?= Html::img('@web/uploads/' . $application->photo, ['alt' => 'Фото', 'style' => 'width:100px']) ?>
            <?php endif; ?>
        </div>

    <?php endforeach; ?>
</div>