<?php

namespace app\models;

use Yii;

/**
 * This is the model class for table "application".
 *
 * @property int $id
 * @property string $surname
 * @property string $name
 * @property string $patronymic
 * @property string $photo
 * @property string $date_birthday
 * @property string $gender
 * @property string $country
 * @property string $passport
 * @property string $education
 * @property string $education_organization
 * @property string $special_qual
 * @property string $diplom
 * @property string $scan_diplom
 * @property string $snils
 * @property string $place_work
 * @property string $post
 * @property string $work_experience
 * @property string $health
 * @property string $phone_number
 * @property string $email
 * @property string $extra_info
 * @property int $user_id
 *
 * @property User $user
 */
class Application extends \yii\db\ActiveRecord
{


    /**
     * {@inheritdoc}
     */
    public static function tableName()
    {
        return 'application';
    }

    /**
     * {@inheritdoc}
     */
    public $passportFiles;

    public function rules()
    {
        return [
            [['surname', 'name', 'patronymic', 'date_birthday', 'gender', 'country', 'passport', 'education', 'education_organization', 'special_qual', 'diplom', 'scan_diplom', 'snils', 'place_work', 'post', 'work_experience', 'health', 'phone_number', 'email', 'extra_info', 'user_id'], 'required'],
            [['date_birthday'], 'safe'],
            [['extra_info'], 'string'],
            [['user_id'], 'integer'],
            [['surname', 'name', 'patronymic', 'photo', 'gender', 'country', 'passport', 'education', 'education_organization', 'special_qual', 'scan_diplom', 'snils', 'place_work', 'post', 'work_experience', 'health', 'email'], 'string', 'max' => 256],
            [['diplom'], 'string', 'max' => 25],
            [['phone_number'], 'string', 'max' => 20],
            [['passportFiles'], 'file', 'skipOnEmpty' => true, 'extensions' => 'jpg, jpeg, pdf', 'maxSize' => 20 * 1024 * 1024, 'maxFiles' => 10],

            [['user_id'], 'exist', 'skipOnError' => true, 'targetClass' => User::class, 'targetAttribute' => ['user_id' => 'id']],
        ];
    }

    public function getPassportFilesArray()
    {
        if (empty($this->passport)) {
            return [];
        }
        return explode('|', $this->passport);
    }


    /**
     * {@inheritdoc}
     */
    public function attributeLabels()
    {
        return [
            'id' => 'ID',
            'surname' => 'Фамилия',
            'name' => 'Имя',
            'patronymic' => 'Отчество',
            'photo' => 'Фото',
            'date_birthday' => 'Дата рождения',
            'gender' => 'Пол',
            'country' => 'Гражданство',
            'passport' => 'Пасспорт',
            'education' => 'Образование',
            'education_organization' => 'Образовательная организация, где получили образование',
            'special_qual' => 'Специальность и квалификация по диплому',
            'diplom' => 'Серия и номер диплома',
            'scan_diplom' => 'Сканирование диплома',
            'snils' => 'СНИЛС',
            'place_work' => 'Место работы',
            'post' => 'Должность',
            'work_experience' => 'Стаж работы',
            'health' => 'Состояние здоровья',
            'phone_number' => 'Номер телефона',
            'email' => 'Email',
            'extra_info' => 'Дополнительная информация',
            'user_id' => 'Пользователь',
            'passportFiles' => 'Сканы паспорта',
        ];
    }

    /**
     * Gets query for [[User]].
     *
     * @return \yii\db\ActiveQuery
     */
    public function getUser()
    {
        return $this->hasOne(User::class, ['id' => 'user_id']);
    }


}
